//
//  MCAutoDialer.h
//  MCApplication
//
//  Created by Michael Clark on Tue Aug 13 2002.
//  Copyright (c) 2001 __MyCompanyName__. All rights reserved.
//

#import <AppKit/AppKit.h>
#import "MCWindowController.h"
#import "MCDialerDeviceProtocol.h"

/////  NSUserDefaults keys
extern NSString *MCAutoDialerLocations;
extern NSString *MCCurrentAutoDialerLocationName;
extern NSString *MCAutoDialerHangupDelay;
extern NSString *MCAutoDialerDialRightAway;


typedef enum _AutoDialerNumberMode {
    LocalAreaCodeWithLocalExchange      = 0,
    LocalAreaCodeWithLDExchange         = 1,
    LDAreaCode                          = 2,
//    NumberUndefined                     = 99
} AutoDialerNumberMode;

@class MCPopupController;
@class MCModemManager;

@interface MCAutoDialer : MCWindowController {
    MCModemManager     *modem;

    IBOutlet MCPopupController      *locationPopController;
    
    IBOutlet NSTextField    *numberTF;
    IBOutlet NSTextField    *statusTF;
    IBOutlet NSMatrix       *stateMatrix;
    IBOutlet NSButton       *closeButton;
    IBOutlet NSButton       *hangupButton;
    IBOutlet NSButton       *dialButton;
    IBOutlet NSButton       *includePrefixCB;
    IBOutlet NSButton       *includeLDPrefixCB;
    IBOutlet NSButtonCell   *ldRadio;
    IBOutlet NSButtonCell   *localRadio;
    IBOutlet NSButtonCell   *localLDRadio;
    IBOutlet NSPopUpButton  *dialerDevicePopUp;
    IBOutlet NSTabView      *tabView;
	IBOutlet NSTextField	*dialerTitleField;
    
    // Number Strings
    NSString      *originalNumber;
    NSString      *parsedNumber;

    // Pieces of the current number
    NSString *areaCode;
    NSString *exchange;
    NSString *theNumber;

    // Used to keep track if we have parsed the number at least once because we need this information
    // to know how to handle the LD prefix switch
    BOOL  isNumberParsed;
    BOOL  isNumberAreaSameAsLocationArea;
    AutoDialerNumberMode numberMode; // to determine what to do on a radio button action

    
    NSMutableArray                  *_locations;
    NSMutableDictionary             *_location;
    
    NSView                          *_mcPrefView;
	
	id		representedObject; // not retained since we are in a modal ...
    
}

+ (void)setAutoDialerClassname:(NSString *)aName;
+ (NSString *)autoDialerClassname;

+ (MCAutoDialer *)defaultInstance;
+ (void)setDefaultInstance:(MCAutoDialer *)aDialer;

+ (void)registerDialerDevice:(id <MCDialerDevice>)device;
+ (NSArray *)dialerDevices;

+ (void)setDefaultDialerDeviceIdentifier:(NSString *)ident;
+ (NSString *)defaultDialerDeviceIdentifier;

+ (id <MCDialerDevice>)defaultDialerDevice;
+ (void)setDefaultDialerDevice:(id <MCDialerDevice>)dialerDevice;


- (void)runModalWithNumberString: (NSString *)number;
- (void)runModalWithNumberString: (NSString *)number representedObject:(id)anObject;

- (void)syncLocationPopup;
- (void) syncLocationWithDefaults;

- (NSString *) parseNumber: (NSString *)number;
- (void) updateUI;
- (void) resetUI;

- (void)disengageDefaultDialerDeviceFromUsage;
- (void)setupDefaultDialerDeviceForUsage;


// Actions
- (IBAction) dial: (id)sender;
- (IBAction) hangup: (id)sender;
- (IBAction) close: (id)sender;
- (IBAction) selectLocalWithLocal: (id)sender;
- (IBAction) selectLocalWithLD: (id)sender;
- (IBAction) selectLD: (id)sender;
- (IBAction) toggleIncludePrefixCB: (id)sender;
- (IBAction) toggleIncludeLDPrefixCB: (id)sender;

// Location dictionary aware methods
- (BOOL) doesLocation: (NSMutableDictionary *)location containLocalAreaCode: (NSString *)areacode;
- (NSMutableDictionary *) localAreaCodeDictionaryForAreaCode: (NSString *)areacode inLocation: (NSMutableDictionary *)location;
- (BOOL) doesLocation: (NSMutableDictionary *)location containLongDistanceExchange: (NSString *)exchange forAreaCode: (NSString *)areacode;
- (NSMutableDictionary *) longDistanceExchangeDictionaryForExchange: (NSString *)exchange
                                               inAreaCodeDictionary: (NSMutableDictionary *)areacode;
- (BOOL) shouldIncludeAreaCodeForLocation: (NSMutableDictionary *)location;
- (void) addAreaCodeAsLocal: (NSString *)areacode toLocation: (NSMutableDictionary *)location;
- (void) addExchangeAsLongDistance: (NSString *)exchange toLocation: (NSMutableDictionary *)location forAreaCode: (NSString *)areacode;
- (NSMutableDictionary *) locationForName: (NSString *) name;
- (void) removeAreaCode: (NSString *) code fromLocation: (NSMutableDictionary *)location;
- (void) removeExchange: (NSString *)anExchange fromLocation: (NSMutableDictionary *)location forAreaCode: (NSString *)areacode;
- (void) clearAreaCode: (NSString *)areacode fromLocation: (NSMutableDictionary *)dict;

- (NSView *)_mcPrefView;

// Accessors
- (void) setOriginalNumber: (NSString *)str;
- (NSString *) originalNumber;
-(void) setParsedNumber: (NSString *)str;
- (NSString *) parsedNumber;
- (NSMutableArray *)locations;
- (void)setLocations: (NSMutableArray *)arr;
- (NSMutableDictionary *)location;
- (void)setLocation: (NSMutableDictionary *)dict;
-(void)setAreaCode:(NSString *)value;
-(NSString *)areaCode;
-(void)setExchange:(NSString *)value;
-(NSString *)exchange;
-(void)setTheNumber:(NSString *)value;
-(NSString *)theNumber;


- (NSTextField *)numberTextField;
- (NSTextField *)statusTextField;
- (NSTextField *)dialerTitleField;
- (NSButton *)closeButton;
- (NSButton *)hangupButton;
- (NSButton *)dialButton;
- (id)representedObject;

@end
